//
//  MCTVSummaryToolbarView.h
//  MCApplication
//
//  Created by Ali Lalani on 7/3/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCTVToolbarView.h"

/*
 Takes an array of display elements, separated by a "bullet" in the view
 Each element has a target, action, and display keypath
*/

@interface MCTVSummaryToolbarView : MCTVToolbarView {
	NSMutableArray *displayElements;
	id model;

	// after iterating through all the display elements, this is the resulting string
	NSMutableAttributedString *_displayElementSummary;

	float summarySideMargin; // how much room on each side to have as a margin, this is doubled to calculate the width

	BOOL __needsRefresh;
}

- (void)addDisplayElementWithKeypath:(NSString *)aKeypath;
- (void)configureWithIdentifier:(NSString *)anIdentifier;

- (void)clearModelObservation;
- (void)resetModelObservation;

- (void)resetDisplayElementSummary;
- (NSDictionary *)displayElementTextAttributes;

- (NSString *)separatorString;

#pragma mark Accessors
- (NSMutableArray *)displayElements;
- (void)setDisplayElements:(NSMutableArray *)aDisplayElements;

- (void)setModel:(id)aModel;
- (id)model;

- (float)summarySideMargin;
- (void)setSummarySideMargin:(float)aSummarySideMargin;
@end
